//
//  MCStackResultsTab.h
//  MCApplication
//
//  Created by Ali Lalani on 10/20/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCStackBackgroundColorView.h"
#import "MCNibLoader.h"
#import "MCStackTabbedPaneTabProtocol.h"
#import "MCMenuManagerSupportProtocol.h"
#import "MCDisplayStateProtocol.h"

@class MCArrayController,MCGenericPlaceholderView;

@interface MCStackResultsTab : MCStackBackgroundColorView <MCStackTabbedPaneTab,MCMenuManagerSupport,MCDisplayState,MCNibDerivedView> {
	IBOutlet MCArrayController *arrayController;

	NSArray *content;

	BOOL _shouldUpdate; // when the view gets moved to a window if this flag is set to YES it will try to update its content

	NSArray *topLevelObjects;

	id parentController;

	MCGenericPlaceholderView *placeholderView;

	NSMutableDictionary *displayState;
	id displayStateDelegate;

	id document;

	id mainWindow;
}
- (void)updateContent;
- (BOOL)resultsDidChange:(NSNotification *)notif;
- (void)setPlaceholderViewState:(BOOL)flag;

// ACCESSORS //
- (NSArray *)content;
- (void)setContent:(NSArray *)aContent;

- (NSArray *)topLevelObjects;
- (void)setTopLevelObjects:(NSArray *)aTopLevelObjects;

- (void)setParentController:(id)anObj;
- (id)parentController;

- (MCGenericPlaceholderView *)placeholderView;
- (void)setPlaceholderView:(MCGenericPlaceholderView *)aPlaceholderView;

- (NSArray *)selectedObjects;

- (BOOL)validateInterface;

- (id)document;
- (void)setDocument:(id)aDocument;
@end
